/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.ROL;
import emulator.unittest.hardware.nmos6502.MockOperand;
import org.junit.Assert;
import org.junit.Test;

public class ROLTest {
    @Test
    public void testRotatePositive() throws EmulatorException {
        this.executeAndCheckROL(0, 8, 0, 16);
    }

    @Test
    public void testRotateNegative() throws EmulatorException {
        this.executeAndCheckROL(1, 64, 128, 129);
    }

    @Test
    public void testRotateNegativeCarry() throws EmulatorException {
        this.executeAndCheckROL(1, 192, 129, 129);
    }

    @Test
    public void testRotateZero() throws EmulatorException {
        this.executeAndCheckROL(0, 128, 3, 0);
    }

    private void executeAndCheckROL(int flags, int val, int expected_flags, int expected_val) throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        MockOperand operand = new MockOperand(val);
        cpu.setFlags(new Flags6502((long)flags));
        new ROL().execute(cpu, operand);
        Assert.assertEquals((Object)new HwByte((long)expected_val), (Object)operand.getByte());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)cpu.getFlags());
    }
}

